<?php
// Exit if accessed directly
if (!defined('ABSPATH')) {
    exit;
}

// Enqueue parent and child theme styles
function vanick_lending_enqueue_styles() {
    $parent_style = 'astra-style';

    wp_enqueue_style($parent_style, get_template_directory_uri() . '/style.css');
    wp_enqueue_style('vanick-lending-style', get_stylesheet_directory_uri() . '/style.css', array($parent_style), wp_get_theme()->get('Version'));
}
add_action('wp_enqueue_scripts', 'vanick_lending_enqueue_styles');


// For Apply Online 

function add_custom_footer_jquery_script() {
    ?>
    <script>
    jQuery(document).ready(function(){
        jQuery(".step_1_btn").click(function(){
            jQuery(".step_2").fadeOut("400");
            jQuery(".step_3").fadeOut("400");
            jQuery(".step_1").delay(400).fadeIn("400").addClass("active");
            jQuery(".info_li_1").addClass("active");
            jQuery(".info_li_2").removeClass("active");
            jQuery(".info_li_3").removeClass("active");
        });
        jQuery(".step_2_btn").click(function(){
            jQuery(".step_1").fadeOut("400");
            jQuery(".step_3").fadeOut("400");
            jQuery(".step_2").delay(400).fadeIn("400").addClass("active");
            jQuery(".info_li_1").removeClass("active");
            jQuery(".info_li_2").addClass("active");
            jQuery(".info_li_3").removeClass("active");
        });
        jQuery(".step_3_btn").click(function(){
            jQuery(".step_1").fadeOut("400");
            jQuery(".step_2").fadeOut("400");
            jQuery(".step_3").delay(400).fadeIn("400").addClass("active");
            jQuery(".info_li_1").removeClass("active");
            jQuery(".info_li_2").removeClass("active");
            jQuery(".info_li_3").addClass("active");
        });
    });
    </script>
    <?php
}

add_action('wp_footer', 'add_custom_footer_jquery_script', 100);




// Add scripts and styles for custom button toggle functionality in the footer
function enqueue_custom_toggle_scripts_footer() {
    // Inline JavaScript for the toggle functionality
    $custom_js = "
        document.addEventListener('DOMContentLoaded', () => {
          // Select buttons by their IDs
          const personalButton = document.getElementById('Personal-Financing');
          const businessButton = document.getElementById('Business-Financing');
          const mortgageButton = document.getElementById('Mortgage-Financing');
          const badCreditButton = document.getElementById('Bad-Credit-Financing');

          // Select content containers by their IDs
          const personalContent = document.getElementById('Personal-Financing-content');
          const businessContent = document.getElementById('Business-Financing-content');
          const mortgageContent = document.getElementById('Mortgage-Financing-content');
          const badCreditContent = document.getElementById('Bad-Credit-Financing-content');

          // Hide all content and show only the selected content
          function showContent(event, selectedContent) {
            event.preventDefault(); // Prevent the default behavior of the button
            event.stopPropagation(); // Stop event propagation
            
            personalContent.classList.remove('active');
            businessContent.classList.remove('active');
            mortgageContent.classList.remove('active');
            badCreditContent.classList.remove('active');

            selectedContent.classList.add('active');
          }

          // Initialize: Show Personal Financing content by default
          personalContent.classList.add('active');

          // Add event listeners to buttons
          personalButton.addEventListener('click', (event) => showContent(event, personalContent));
          businessButton.addEventListener('click', (event) => showContent(event, businessContent));
          mortgageButton.addEventListener('click', (event) => showContent(event, mortgageContent));
          badCreditButton.addEventListener('click', (event) => showContent(event, badCreditContent));
        });
    ";

    // Inline CSS for styling content containers
    $custom_css = "
        #Personal-Financing-content,
        #Business-Financing-content,
        #Mortgage-Financing-content,
        #Bad-Credit-Financing-content {
          display: none;
          box-shadow: 0 2px 4px rgba(0, 0, 0, 0.1);
        }

        #Personal-Financing-content.active,
        #Business-Financing-content.active,
        #Mortgage-Financing-content.active,
        #Bad-Credit-Financing-content.active {
          display: block;
        }
    ";

    // Output JavaScript and CSS in the footer
    echo '<style>' . $custom_css . '</style>';
    echo '<script>' . $custom_js . '</script>';
}
add_action('wp_footer', 'enqueue_custom_toggle_scripts_footer');







// Register the shortcode
function loan_calculator_shortcode() {
    // HTML content of the Loan Calculator
    ob_start();
    ?>
    <div id="loan-calculator-wrapper">
        <h2>Loan Calculator</h2>

        <!-- Loan Form -->
        <form id="loan-calculator-form" action="https://demo.luvcite.net/vanick-lending/apply-online/" method="POST">
            <!-- Loan Amount Slider -->
            <div class="field-group">
                <h3>How much cash do you need?</h3>
                <input
                    type="range"
                    id="loan-amount-slider"
                    name="loan_amount"
                    min="500"
                    max="5000"
                    step="100"
                    value="500"
                >
                <label>Selected Loan Amount: <strong id="loan-amount-display">$500</strong></label>
            </div>

            <!-- Purpose of Loan -->
            <div class="field-group">
                <h3>Purpose of Loan</h3>
                <select id="loan-purpose" name="loan_purpose">
                    <option value="Personal">Personal</option>
                    <option value="Business">Business</option>
                    <option value="Education">Education</option>
                    <option value="Medical">Medical</option>
                    <option value="Vacation">Vacation</option>
                </select>
            </div>

            <!-- Loan Summary Section -->
            <div id="loan-summary">
                <h3>Loan Summary:</h3>
                <p>
                    <strong id="summary-amount">$500</strong> for 
                    <strong id="summary-purpose">Personal</strong>
                </p>
            </div>

            <!-- Submit Button -->
            <button type="submit" id="submit-button">Submit Loan Request</button>
        </form>
    </div>

    <style>
        #loan-calculator-wrapper {
            max-width: 600px;
            margin: 20px auto;
            padding: 20px;
            background: #fff;
            border-radius: 10px;
            box-shadow: 0 4px 8px rgba(0, 0, 0, 0.1);
        }

        #loan-calculator-wrapper h2,
        #loan-calculator-wrapper h3 {
            color: #444;
        }

        .field-group {
            margin-bottom: 20px;
        }

        #loan-amount-slider {
            -webkit-appearance: none;
            width: 100%;
            height: 15px;
            background: linear-gradient(to right, #ffc107 0%, #ddd 0%);
            border-radius: 5px;
            outline: none;
            cursor: pointer;
            transition: background 0.3s ease;
        }

        #loan-amount-slider::-webkit-slider-thumb {
            -webkit-appearance: none;
            width: 30px;
            height: 30px;
            margin-top:-10px;
            background: #ffc107;
            border-radius: 50%;
            border: 2px solid #fff;
            box-shadow: 0 2px 4px rgba(0, 0, 0, 0.2);
            cursor: pointer;
        }

        #loan-purpose {
            width: 100%;
            padding: 10px;
            border: 1px solid #ccc;
            border-radius: 5px;
            font-size: 16px;
        }

        #loan-summary {
            margin-top: 20px;
            margin-bottom:20px;
            padding: 15px;
            background: #f8f9fa;
            border: 1px solid #ddd;
            border-radius: 8px;
            font-size: 16px;
        }

        #submit-button {
            width: 100%;
            padding: 12px;
            background: #ffc107;
            color: #fff;
            border: none;
            border-radius: 5px;
            font-size: 16px;
            cursor: pointer;
        }
    </style>

    <script>
        document.addEventListener('DOMContentLoaded', function () {
            const slider = document.getElementById('loan-amount-slider');
            const loanAmountDisplay = document.getElementById('loan-amount-display');
            const loanPurpose = document.getElementById('loan-purpose');
            const summaryAmount = document.getElementById('summary-amount');
            const summaryPurpose = document.getElementById('summary-purpose');

            slider.addEventListener('input', function () {
                const value = slider.value;
                loanAmountDisplay.textContent = `$${value}`;
                summaryAmount.textContent = `$${value}`;

                const percentage = ((value - slider.min) / (slider.max - slider.min)) * 100;
                slider.style.background = `linear-gradient(to right, #ffc107 ${percentage}%, #ddd ${percentage}%)`;
            });

            loanPurpose.addEventListener('change', function () {
                summaryPurpose.textContent = loanPurpose.value;
            });

            slider.dispatchEvent(new Event('input'));
        });
    </script>
    <?php
    return ob_get_clean();
}

// Add the shortcode
add_shortcode('loan_calculator', 'loan_calculator_shortcode');


